
/*-----------------13.07.99 00:21-------------------
 ᠭ  ⮫쭮 ࠤ Kishinev
  ᠬ  㡫 ex-USSR Moldova
 , 訬 ᥡ ணࠬ஬   Ruslan Mohniuc
  ᢮   ६.
 ।஢   ﬨ  ᢮  ᭠ ६
 ᯥ樠쭮  RU.EMBEDDED

ணࠬ ਧ / , ࠡ饥  ⮪ I2C
 ⥭  設-  
 砭  ணࠬ- : 2:469/47.3  exeplus@mail.ru

 ᫥ 奬 祭 (⭮ ࠭  쬠 Dima Orlov 2:461/27)


           24C16                 LPT
      1Ŀ8
 ĴA0  E Vcc>D1  (Pin 3)
     2    E    7   
 ĴA1  P  WP 0 \15k
    3    R    6   \
 ĴA2  O SCLĿ >D2  (Pin 4)
   4    M    5  
  ĴGND   SDA>ACK (Pin 10)
     
                / 
              Ĵ      KT3102
             \ 
             \  
           1k\       >D0  (Pin 2)
                    
              
  >GND (Pin 25)
 
 >D3  (Pin 5)
 
 >D4  (Pin 6)
 
 >D5  (Pin 7)


 ᫥ ᠭ ਬ塞 㫥:


wait5us() - প  5 
wait5us() - প  10 
wait10ms() - প  10  
wait100ms()- প  100  
init_lpt() - 樠 LPT- 
lpt_off() - 몫祭 殮   믮 ணࠬ
bsf_scl()-  ⠭ SCL   "1"
bcf_scl()-  ⠭ SCL   "0"
bsf_sda()-  ⠭ SDA   "1"  
            ६- ॢ SDA   (..  室 ⨯ "OK")
bcf_sda()-  ⠭ SDA   "0"  
start()-    "START" I2C
stop()-     "STOP" I2C
i2c_bitout()- । 
i2c_bitin()- ਥ 
tx_byte()- । 
rx_byte_nack()- ਥ   뤠 ACK
rx_byte_ack()- ਥ  c 뤠祩 ACK
i2ctxbyte_16()-    24LC16
i2crxbyte_16()- ⥭   24LC16
i2crxblock_16()- ⥭   24LC16
i2ctxbyte_256()-    24LC256
i2ctxpage_256()-    24LC256
ack_polling()-  ⢥ "ACK" (砭 )
i2crxblock_256()- ⥭   24LC256
i2crxbyte_256()- ⥭   24LC256
wait_presskey()-  ⨥  
read_fail_256() - ⥭   EEPROM 24LC256  䠩
read_screen_256()- 뢮   EEPROM 24LC256  ࠭
init_eeprom_256()- 樠 EEPROM 24LC256 ⮬ 0x00


 "24LC16"     ⪨  (2 )
 "24LC256"       (2 )

஡   24LC16  24LC256-  祬   :)

--------------------------------------------------*/


#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <bios.h>
#include <dir.h>

#include <dir.h>
FILE *stream;

unsigned int lpt378=0x0378, lpt379=0x379;
unsigned char  ACK= 0x40, SCL= 0x04, SDA= 0x01;
unsigned char  i2cdat, i2cbuf,i2cerr, i2cdat16[16], i2cdat64[64];
unsigned int i2cadr, argc;

unsigned char namefile[30];


void wait5us(void);
void wait10us(void );
unsigned char init_lpt(void );
void bsf_scl(void );
void bcf_scl(void );
void bsf_sda(void );
void bcf_sda(void );
void start(void );
void stop(void );
void i2c_bitout(unsigned char bit);
unsigned char i2c_bitin(void );
void tx_byte(unsigned char byte);
void rx_byte_ack(void );
void rx_byte_nack(void );
void i2ctxbyte_256(void );
void lpt_off(void);
void i2crxblock_256(void);
void wait10ms(void);
void wait100ms(void);
unsigned char ack_polling(void);





void wait5us(void)
{
	inportb (lpt379);
	inportb (lpt379);
	return;
}

void wait10us()
{
	inportb (lpt379);
	inportb (lpt379);
	inportb (lpt379);
        return;
}

void wait10ms()
{
        unsigned int i;
        for ( i=0;i<1000;i++ )
        {
                wait10us();
        }
        return;
}

void wait100ms()
{
        unsigned char i;
        for ( i=0;i<10;i++ )
        {
                wait10ms();
        }
        return;
}



/*-----------------06.07.99 09:28-------------------
     樠 LPT-  EEPROM
--------------------------------------------------*/
unsigned char init_lpt()
{
        unsigned char tmp1;
	outportb(lpt378,0x00);      /*   D1  砥 ⢨ "1"  ACK  */
	outportb(lpt378,0x02);      /* D1="1" (+5V)  */
        wait100ms();
	stop();
        tmp1 = (inportb (lpt379)) & ACK;
        if ( tmp1 == 0 ) return(1);  /* error */
        return (0);   /* ଠ쭮 襭 */
}

void lpt_off()
{
        outportb(lpt378,0x00);
        return;
}

/*-----------------06.07.99 09:41-------------------
     ⠭ SCL   "1"
--------------------------------------------------*/
void bsf_scl()
{
        unsigned char tmp1;
        tmp1= inportb (lpt378);
        tmp1= tmp1 | SCL;
        outportb(lpt378,tmp1);
        return;
}

/*-----------------06.07.99 09:41-------------------
     ⠭ SCL   "0"
--------------------------------------------------*/
void bcf_scl()
{
        unsigned char tmp1;
        tmp1= inportb (lpt378);
        tmp1= tmp1 & (SCL ^ 0xff);
        outportb(lpt378,tmp1);
        return;
}

/*-----------------06.07.99 09:41-------------------
     ⠭ SDA   "1"
     ६- ॢ SDA   (..  室 ⨯ "OK")
--------------------------------------------------*/
void bsf_sda()
{
        unsigned char tmp1;
        tmp1= inportb (lpt378);
        tmp1= tmp1 & (SDA ^ 0xff);
        outportb(lpt378,tmp1);
        return;
}

/*-----------------06.07.99 09:41-------------------
     ⠭ SDA   "0"
--------------------------------------------------*/
void bcf_sda()
{
        unsigned char tmp1;
        tmp1= inportb (lpt378);
        tmp1= tmp1 | SDA;
        outportb(lpt378,tmp1);
        return;
}


/*-----------------06.07.99 09:40-------------------
            START
--------------------------------------------------*/
void start()
{
	bsf_sda();
	bsf_scl();
	wait5us();
        bcf_sda();
        wait5us();
        bcf_scl();
}


/*-----------------06.07.99 10:07-------------------
                STOP
--------------------------------------------------*/
void stop()
{
	bcf_sda();
	bsf_scl();
        wait5us();
	bsf_sda();
	wait5us();
	return;
}

void i2c_bitout(unsigned char bit)
{
        if ( bit !=0x00 )
        {
                 bsf_sda();
        }
        else
        {
                bcf_sda();
        }

        wait10us();
        bsf_scl();
        wait10us();
        bcf_scl();
        return;
}

unsigned char i2c_bitin()
{
        unsigned char bit;
        bsf_sda();      /* sda-   */
        wait5us();
        bsf_scl();
        wait10us();
        bit= inportb(lpt379) & ACK;
        bcf_scl();
        if ( bit == 0 ) return(0);
                else    return(1);
}

void tx_byte(unsigned char byte)
{
        i2c_bitout (byte & 0x80);
        i2c_bitout (byte & 0x40);
        i2c_bitout (byte & 0x20);
        i2c_bitout (byte & 0x10);
        i2c_bitout (byte & 0x08);
        i2c_bitout (byte & 0x04);
        i2c_bitout (byte & 0x02);
        i2c_bitout (byte & 0x01);
	if ( i2c_bitin() == 1 ) i2cerr=1;
        return;
}

void rx_byte_nack()
{
        i2cbuf=0x00;
        if ( i2c_bitin() == 1 )  i2cbuf= i2cbuf | 0x80;
        if ( i2c_bitin() == 1 )  i2cbuf= i2cbuf | 0x40;
        if ( i2c_bitin() == 1 )  i2cbuf= i2cbuf | 0x20;
        if ( i2c_bitin() == 1 )  i2cbuf= i2cbuf | 0x10;
        if ( i2c_bitin() == 1 )  i2cbuf= i2cbuf | 0x08;
        if ( i2c_bitin() == 1 )  i2cbuf= i2cbuf | 0x04;
        if ( i2c_bitin() == 1 )  i2cbuf= i2cbuf | 0x02;
        if ( i2c_bitin() == 1 )  i2cbuf= i2cbuf | 0x01;
        i2c_bitout (0x01);       /* nack */
        return;
}


void rx_byte_ack()
{
        i2cbuf=0x00;
        if ( i2c_bitin() == 1 )  i2cbuf= i2cbuf | 0x80;
        if ( i2c_bitin() == 1 )  i2cbuf= i2cbuf | 0x40;
        if ( i2c_bitin() == 1 )  i2cbuf= i2cbuf | 0x20;
        if ( i2c_bitin() == 1 )  i2cbuf= i2cbuf | 0x10;
        if ( i2c_bitin() == 1 )  i2cbuf= i2cbuf | 0x08;
        if ( i2c_bitin() == 1 )  i2cbuf= i2cbuf | 0x04;
        if ( i2c_bitin() == 1 )  i2cbuf= i2cbuf | 0x02;
        if ( i2c_bitin() == 1 )  i2cbuf= i2cbuf | 0x01;
        i2c_bitout (0x00);       /* ack */
        return;
}






/*-----------------06.07.99 10:35-------------------
;-----------------------------------------------------------------------------
;       BYTE-WRITE, write one byte to EEPROM device (24LC16)
;-----------------------------------------------------------------------------
;       Input   :       I2CDAT= data to be written
;                       I2CADRL,I2CADRH    = destination address
;       Output  :       Data written to EEPROM device
;-----------------------------------------------------------------------------
--------------------------------------------------*/
void i2ctxbyte_16()
{
	unsigned char tmp1;
	stop();
        start();
	tmp1= (i2cadr>>7) & 0x0e;
        tmp1= tmp1 | 0xa0;
        tx_byte (tmp1);         /* CONTROL BYTE ;ADRESS, HIGH BYTE */
        tx_byte ((i2cadr & 0xff));      /* ADRESS, LOW BYTE */
        tx_byte (i2cdat);       /* DATA */
        stop();
        return;
}


/*-----------------06.07.99 10:44-------------------
;-----------------------------------------------------------------------------
;       BYTE-READ, read one byte from serial EEPROM device (24LC16)
;-----------------------------------------------------------------------------
;       Input   :       I2CADRL    = source address
;                       I2CADRH   = device address (1010xxx0)
;       Output  :       I2CDAT   = data read from serial EEPROM
;-----------------------------------------------------------------------------
--------------------------------------------------*/
void i2crxbyte_16()
{
	unsigned char tmp1;
	stop();
        start();
	tmp1= (i2cadr >>7) & 0x0e;
        tmp1= tmp1 | 0xa0;
        tx_byte (tmp1);         /* CONTROL BYTE ;ADRESS, HIGH BYTE */
        tx_byte ((i2cadr & 0xff));      /* ADRESS, LOW BYTE */
        start();
	tmp1= (i2cadr >>7) & 0x0e;
	tmp1= tmp1 | 0x01;
        tmp1= tmp1 | 0xa0;
        tx_byte (tmp1);         /* CONTROL BYTE ;ADRESS, HIGH BYTE */
        rx_byte_nack();
        stop();
        i2cdat = i2cbuf;
        return;
}


/*-----------------06.07.99 10:44-------------------
;-----------------------------------------------------------------------------
;       BLOCK-READ, read 16 bytes from serial EEPROM device (24LC16)
;-----------------------------------------------------------------------------
;       Input   :       I2CADRL,I2CADRH    = begin source address
;       Output  :       I2CDAT16[0..15]   = data read from serial EEPROM
;-----------------------------------------------------------------------------
--------------------------------------------------*/
void i2crxblock_16()
{
	unsigned char tmp1;
	unsigned int i;

	stop();
        start();
        tmp1= (i2cadr >>7) & 0x0e;
        tmp1= tmp1 | 0xa0;
        tx_byte (tmp1);         /* CONTROL BYTE ;ADRESS, HIGH BYTE */
        tx_byte (i2cadr & 0xff);      /* ADRESS, LOW BYTE */
        start();
        tmp1= (i2cadr >>7) & 0x0e;
	tmp1= tmp1 | 0x01;
        tmp1= tmp1 | 0xa0;
        tx_byte (tmp1);         /* CONTROL BYTE ;ADRESS, HIGH BYTE */

	for ( i=0;i<15;i++ )
        {
		rx_byte_ack();
                i2cdat16[i] = i2cbuf;
	}
        rx_byte_nack();
        i2cdat16[15] = i2cbuf;
        stop();
	return;


}



/*-----------------06.07.99 10:35-------------------
;-----------------------------------------------------------------------------
;       BYTE-WRITE, write one byte to EEPROM device (24LC256)
;-----------------------------------------------------------------------------
;       Input   :       I2CDAT= data to be written
;                       I2CADRL,I2CADRH    = destination address
;       Output  :       Data written to EEPROM device
;-----------------------------------------------------------------------------
--------------------------------------------------*/
void i2ctxbyte_256()
{
	unsigned char tmp1;
	stop();
        start();
        tx_byte (0xa0);          /* CONTROL BYTE */
	tx_byte ((i2cadr >>8) & 0xff);      /* ADRESS, HIGH BYTE */
	tx_byte (i2cadr & 0xff);      /* ADRESS, LOW BYTE */
        tx_byte (i2cdat);       /* DATA */
        stop();
        return;
}

/*-----------------06.07.99 10:35-------------------
;-----------------------------------------------------------------------------
;       PAGE-WRITE, write page to EEPROM device (24LC256)
;-----------------------------------------------------------------------------
;       Input   :       I2CDAT[0..63] = data to be written
;                       I2CADRL,I2CADRH    = destination address
;       Output  :       Data written to EEPROM device
;-----------------------------------------------------------------------------
--------------------------------------------------*/
void i2ctxpage_256()
{
        unsigned int i;
	stop();
        start();
        tx_byte (0xa0);          /* CONTROL BYTE */
	tx_byte ((i2cadr >>8) & 0xff);      /* ADRESS, HIGH BYTE */
	tx_byte (i2cadr & 0xff);      /* ADRESS, LOW BYTE */
        for ( i= 0; i<64; i++ )
        {
                tx_byte (i2cdat64[i]);       /* DATA */
        }
        stop();
        return;
}


unsigned char ack_polling()
{
       unsigned char byte = 0xa0;
       unsigned del = 2000;  /*   SDA=1  ~20ms */
l1:;
        del=del-1;
        if ( del == 0 ) return (1);
        start();
      /* tx_byte */
        i2c_bitout (byte & 0x80);
        i2c_bitout (byte & 0x40);
        i2c_bitout (byte & 0x20);
        i2c_bitout (byte & 0x10);
        i2c_bitout (byte & 0x08);
        i2c_bitout (byte & 0x04);
        i2c_bitout (byte & 0x02);
        i2c_bitout (byte & 0x01);
        stop();
        if ( i2c_bitin() == 1 ) goto l1;
        return (0);

}





/*-----------------06.07.99 10:44-------------------
;-----------------------------------------------------------------------------
;       BLOCK-READ, read 16 bytes from serial EEPROM device (24LC256)
;-----------------------------------------------------------------------------
;       Input   :       I2CADRL,I2CADRH    = begin source address
;       Output  :       I2CDAT16[0..15]   = data read from serial EEPROM
;-----------------------------------------------------------------------------
--------------------------------------------------*/
void i2crxblock_256()
{
	unsigned char tmp1;
	unsigned int i;
	stop();
	start();
        tx_byte (0xa0);          /* CONTROL BYTE */
	tx_byte ((i2cadr >>8) & 0xff);      /* ADRESS, HIGH BYTE */
        tx_byte ((i2cadr & 0xff));      /* ADRESS, LOW BYTE */
        start();
        tx_byte (0xa1);          /* CONTROL BYTE */

	for ( i=0; i<15; i++)
        {
                rx_byte_ack();
		i2cdat16[i] = i2cbuf;
        }
	rx_byte_nack();
	i2cdat16[15]= i2cbuf;

	stop();
        return;
}
/*
;-----------------------------------------------------------------------------
;       BYTE-READ, read one byte from serial EEPROM device (24LC256)
;-----------------------------------------------------------------------------
;       Input   :       I2CADRL    = source address
;                       I2CADRH   = device address (1010xxx0)
;       Output  :       I2CDAT   = data read from serial EEPROM
;-----------------------------------------------------------------------------
--------------------------------------------------*/
void i2crxbyte_256()
{
	stop();
        start();
        tx_byte (0xa0);          /* CONTROL BYTE */
	tx_byte ((i2cadr >>8) & 0xff);      /* ADRESS, HIGH BYTE */
	tx_byte (i2cadr & 0xff);      /* ADRESS, LOW BYTE */
        start();
        tx_byte (0xa1);          /* CONTROL BYTE */
        rx_byte_nack();
        stop();
        i2cdat = i2cbuf;
        return;
}


void wait_presskey()
{
l1:;    if (kbhit()==0) goto l1;
        return;
}

/*
 
*/

/*-----------------07.07.99 10:43-------------------
        ⥭   EEPROM 16LC256  䠩
--------------------------------------------------*/
 read_fail_256()
 {
	unsigned int i;
	i2cerr = 0;
	clrscr();
        if (init_lpt() != 0)
        {
                clrscr();
                cprintf (" .1  設 ACK");
                goto l5;   /* 訡  樠樨 */
        }
l3:;
        clrscr();
        if ( argc ==1 )
        {
                printf ("  䠩 => ");
                scanf ("%s",namefile);
        }

   /* ஡㥬  䠩 */

	stream = fopen (namefile,"r");
	if ( stream != NULL)
        {
                cprintf (" \n  '%s' 㦥 . ? (y/n)",namefile);
		fclose (stream);
                if (getch()!= 'y')
                {
                        goto l3;
                }
                else
                {
                        if (argc ==3  )
                        {
                                stream=fcloseall();
                                lpt_off();
                                return;
                        }
                }


        }
   /* 뢠 䠩 */

	stream = fopen (namefile,"w");

  /* 蠯 䠩 */
        fprintf ( stream,"    EEPROM 24LC256 ");

  /*-----------------22.04.99 17:31-------------------
     砫 横 ⥭
  --------------------------------------------------*/

	for ( i2cadr = 0x00; i2cadr<0x8000;i2cadr=i2cadr+16 )
        {
		i2crxblock_256();
		fprintf ( stream,"\n %04x ",i2cadr);
                for ( i= 0;i<16;i++ )
                {
			fprintf ( stream," %02x",i2cdat16[i]);
                }
                if ( i2cerr != 0 )
		{
			clrscr();
                        cprintf ("訡  ⥭ ");
			goto l5;
		}
	gotoxy (5,20);
        printf ( "⠫  0x%04x ",(0x7fff-i2cadr)-0x0f);
        }
l5:;
	stream=fcloseall();
	lpt_off();
        gotoxy (5,24);
        printf ( "Press any key to continue ");
        wait_presskey();
        return;
 }



/*-----------------07.07.99 10:43-------------------
         뢮   EEPROM 16LC256  ࠭
--------------------------------------------------*/
 read_screen_256()
 {
	unsigned int i, tmp_i2cadr;
	unsigned char tmp2;
	i2cerr = 0;
        clrscr();
        if (init_lpt() != 0)
        {
                clrscr();
                cprintf (" .1  設 ACK");
                goto l5;   /* 訡  樠樨 */
        }
  /*-----------------22.04.99 17:31-------------------
     砫 横 ⥭
  --------------------------------------------------*/

	gotoxy (1,2);
l1:;
        tmp_i2cadr = i2cadr;
        for ( i2cadr= tmp_i2cadr; i2cadr<(tmp_i2cadr+0x100); i2cadr= i2cadr+16 )
        {

		i2crxblock_256();
                cprintf ( "\n\r %04x",i2cadr);
                for ( i= 0;i<16;i++ )
                {
                        cprintf ( " %02x ",i2cdat16[i]);
                }
                if ( i2cerr != 0 )
		{
			clrscr();
                        cprintf ("訡  ⥭ ");
			goto l5;
                }
        }

        gotoxy (5,20);
        printf ( "Press any key to continue (+ 0x0100)");
        printf ("\n\r'-' -left (-0x0100)");
        printf ("\n\r'+' -right (+0x1000)");
        printf ("\n\r'0' -exit (-0x0100)");
        tmp2= getch();

        if ( tmp2 =='0' ) return;
	if ( tmp2 =='-' ) i2cadr = (i2cadr - 0x0100)-0x0100;
	if ( tmp2 =='+' ) i2cadr = (i2cadr + 0x1000)-0x0100;
        i2cadr = i2cadr & 0x7fff;
        gotoxy (1,2);
        goto l1;

l5:;
	lpt_off();
        gotoxy (5,24);
        printf ( "Press any key to continue ");
        wait_presskey();
        return;
 }


 /*-----------------07.07.99 10:52-------------------
        樠 EEPROM 16LC256 ⮬ 0x00
 --------------------------------------------------*/
 void init_eeprom_256()
 {
	unsigned int i;
        unsigned char eeprom_const=0x00;
	i2cerr = 0;
        if (init_lpt() != 0)
        {
                clrscr();
                cprintf (" .1  設 ACK");
                goto l5;   /* 訡  樠樨 */
        }
        i2cerr = 0;
        for ( i=0;i<64;i++ ) i2cdat64[i]=eeprom_const;

	for ( i2cadr = 0x0000; i2cadr<0x8000; i2cadr=i2cadr+64)
	{
                i2ctxpage_256();
		if ((ack_polling() != 0) || (i2cerr != 0))
                {
                        clrscr();
                        cprintf ("訡   ");
                        goto l5;
                }
                gotoxy (5,20);
		cprintf ( "⠫  0x%04x ",(0x7fff-i2cadr)-0x3f);

        }
     /*-----------------07.07.99 11:49-------------------
      ஢ઠ 
     --------------------------------------------------*/
  /*-----------------22.04.99 17:31-------------------
     砫 横 ⥭
  --------------------------------------------------*/
	for ( i2cadr= 0x0000; i2cadr<0x8000; i2cadr=i2cadr+16)
        {
		i2crxblock_256();
                for ( i= 0;i<16;i++ )
                {
                        if ( i2cdat16[i]!= eeprom_const )
                        {
                                clrscr();
                                cprintf ("訡  䨪樨  ");
                                goto l5;
                        }
                }
                if ( i2cerr != 0 )
		{
			clrscr();
                        cprintf ("訡  ⥭ ");
			goto l5;
                }
		gotoxy (5,20);
		printf ( "⠫ ஢ 0x%04x ",(0x7fff-i2cadr)-0x0f);
        }
        printf ( " \n\r   OK");

l5:;
	lpt_off();
        gotoxy (5,24);
        printf ( "Press any key to continue ");
        wait_presskey();
        return;
 }



/*
 
*/
void main (int n_arg, char **argv)
{
	unsigned int i, flag2=0xff,a1,a2;
	unsigned char N_option;


        argc= n_arg;
        if ( argc == 1 ) goto  main_cont;
        switch(argc)
        {
                case 2: sscanf (argv[1], "%d", &N_option);break;
                case 3:
                        {
                                sscanf (argv[1], "%d", &N_option);
                                sscanf (argv[2], "%s", &namefile);
                        }
                default:           ;
        }
        if ( (argc > 3) || (N_option!=1) || (N_option!=1))
        {
		printf ("\n\r\n\r i2c.exe [npar] [filename]");
		printf ("\n\r npar: 1- read data from EEPROM to file");
		printf ("\n\r       3- clear all EEPROM ");
		printf ("\n\r filename- for [npar=1]\n\r\n\r");
                return;
        }

	if ( (N_option == 0x01) && argc == 3 )
        {

	    read_fail_256();
            return;
        }

	if ( (N_option == 0x03) && argc == 2 )
        {
            init_eeprom_256();
            return;
        }


main_cont:;

    while ( flag2!='0' )
    {
        clrscr();
	cprintf("  ?");
        cprintf("\n\r  1 - ⥭   EEPROM 16LC256  䠩");
        cprintf("\n\r  2 - 뢮   EEPROM 16LC256  ࠭");
        cprintf("\n\r  3 - 樠 EEPROM 16LC256 ⮬ 0x00");
        cprintf("\n\r  0-  室  ணࠬ\n\n\r");
        scanf("%u",&flag2);
        switch(flag2)
        {
            case 1:     read_fail_256();break;
            case 2:     read_screen_256();break;
            case 3:     init_eeprom_256();break;
	    case 0:  	goto end; break;
            default:           ;
        }
    }
end:;
	lpt_off();
        return;
}


